#MTMM syntax  Mplus R
#last updated 22-08-2017
# built with R 3.3.0
# questions: p.lugtig@uu.nl



# EXTRA ANALYSES FOR POLTRUST AND LEFTRIGHT

rm(list=ls(all=TRUE))
#setwd("C:/Users/plugtig/dropbox/Peter/common metric/")
setwd("D:/SURFdrive/Onderzoek/common metric/")
#install R to mplus
#install.packages("MplusAutomation")
library("MplusAutomation")

# create input files from template

# 2. meref models
createModels("D:/SURFdrive/Onderzoek/common metric/template MTMM political trust meref.txt")
createModels("D:/SURFdrive/Onderzoek/common metric/template MTMM leftright meref.txt")
runModels("D://SURFdrive/Onderzoek/common metric/political trust meref", recursive=T,showOutput=T)
runModels("D://SURFdrive/Onderzoek/common metric/leftright meref", recursive=T,showOutput=T)

alloutput1 <- readModels("D:/SURFdrive/Onderzoek/common metric/political trust meref", recursive = T)
alloutput2 <- readModels("D:/SURFdrive/Onderzoek/common metric/leftright meref", recursive = T)
# ignore the warnings

# alternative
fit1 <- extractModelSummaries("D:/SURFdrive/Onderzoek/common metric/political trust meref", recursive=T)
fit2 <- extractModelSummaries("D:/SURFdrive/Onderzoek/common metric/political trust meref", recursive=T)
results1 <- extractModelParameters("D:/SURFdrive/Onderzoek/common metric/leftright meref", recursive=T)
results2 <- extractModelParameters("D:/SURFdrive/Onderzoek/common metric/leftright meref", recursive=T)

View(fit1)
View(fit2)

##########################################################################################
################# PROCESS THE MTMM DATA #################################################
##########################################################################################


# NOTE THAT THE VAR LABELS AREE INCORRECT. THIS IS JUST FOR CHECKING RESULTS


######################### now import from the multigroup files ################
# first pol trust (which actally is social trust)
# extract the means of traits from file 
# and now extract all relevant parameter estimates 
# make sure that all models run and fit
test0 <- results1
test22 <- as.matrix(unlist(test0),nrow=126,byrow=T)
test3 <- matrix(unlist(test22),nrow=3636,byrow=F)

# extract means, with their se's 
meanstraits <- test3[c(286:288),]
meanmethodfactor <- test3[c(289:291),]
#View(meanmethodfactor)
meantraitse <- test3[c(412:414),]
meanfactorse <- test3[c(415:417),]
# extract trait loadings (for reliability and validity)
traitloadings <-test3[c(1243:1251),]
methodloadings <-test3[c(1252:1260),]
reliabilities <- test3[c(1297:1305),]

#View(traitloadings)
#View(methodloadings)
# now, take the longitudinal datasets, and substract the cross-sectional estimates from wave 1
# because longitudinal datasets is saved as factors, need to change it again 
# make the wave 1 of same size
MTMMmethod <- as.data.frame(matrix(rep(MTMMmethodmeans,35),nrow=3,ncol=35))
Cmethodmeans <- cbind(as.numeric(unlist(MTMMmethod)) - as.numeric(meanmethodfactor))
#View(Cmethodmeans)

# here, we are not merely interested in method means. But in overall variation in method means
# stole this from http://stackoverflow.com/questions/9379065/how-to-sum-grouped-elements-of-a-vector-in-r
# first make it into absolute number
meanmethodfactor <- as.numeric(unlist(meanmethodfactor))
absmethodmeans <- abs(as.numeric(Cmethodmeans)/2)
# View(absmethodmeans)
# then, apply mean function to it.
methodvariation <- tapply(absmethodmeans, (seq_along(absmethodmeans)-1) %/% 3,mean)
#View(methodvariation)

# traitmeans
test4 <- as.numeric(as.character(unlist(meanstraits)))
Ctraitmeans  <- test4 - MTMMtraitmeans

#traitloadings - validity
test5 <- as.numeric(as.character(unlist(traitloadings)))
Ctraitloadings <- test5 - MTMMtraitloadings

#methodloadings - method effects
test6 <- as.numeric(as.character(unlist(methodloadings)))
Cmethodloadings <- as.data.frame(test6 - MTMMmethodloadings)
View(test6)

#reliability
test7 <- 1-as.numeric(as.character(unlist(reliabilities)))
Creliability <- test7 - MTMMreliability

#View(MTMMvalidity)
# compute validity coefficient
validity <- test5
reliability <- test7
#test7 <- as.numeric(as.character(unlist(validity)))
# produces change in validity estimates
Cvalidity <- as.data.frame(validity - MTMMvalidity)
View(Cvalidity)

#test8 <- as.numeric(as.character(unlist(regression)))
#Cregression <- test8 - MTMMregression 

################ now combine item into two objects for plottting
# 9-item for loadings
# 3 items for means + regressioncoefficients 
View(validity)
loadingscombined <- as.data.frame(cbind(reliability,Creliability,validity,Cvalidity)) #1.
meanmethodfactor <- as.numeric(as.character(unlist(meanmethodfactor))) # make it numeric as well
meansbcombined <- as.data.frame(cbind(Ctraitmeans,meanmethodfactor,Cmethodmeans)) #2.
#View(Cmethodmeans)

meansbcombined$methodvariation <- rep(methodvariation)
#View(meansbcombined$methodvariation)
meansbcombined$MTMMmeans <- rep(MTMMmethodmeans,c(35))

#class(loadingscombined)
# now add some handy columns for creating the plots
meansbcombined$latent <- rep(1:3)
loadingscombined$latent <- rep(1:9)
meansbcombined$wave <-   rep(1:35,c(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3))
loadingscombined$wave <- rep(1:35,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))
# now, add one variable that reflects the mean in the change in quality (no longer used)
#loadingsmean <- tapply(loadingscombined$Cquality, (seq_along(loadingscombined$Cquality)-1) %/% 9, mean)
#loadingscombined$means <- rep(loadingsmean,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))

# add up differences in trait and method means
# for this, need to ceate a product matrix - 3 x3.

######################################################################
# I want moving averages to make the plot look nicer. Here is a function I stole 
# http://druedin.com/2012/08/11/moving-averages-in-r/

mav <- function(x,n=3){filter(x,rep(1/n,n), sides=2)}
# ah crap. I need to change the order of the matrix, so that it is ordered on latent.
# use the order variable to order on latent variable
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
#now, add this moving average to the data frame
meansbcombined$mavtraitmeans <- as.numeric(mav(meansbcombined$Ctraitmeans))
# impose a 0 for the first 2 waves (they get an NA in the mav-function)
meansbcombined$mavtraitmeans[meansbcombined$wave <3] <- 0

# now do the same for the method means
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodmeans <- as.numeric(mav(meansbcombined$meanmethodfactor))
meansbcombined$mavmethodmeans[meansbcombined$wave <3] <- 0

#now do the same for method variation 
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodvariation <- as.numeric(mav(meansbcombined$methodvariation))
meansbcombined$mavmethodvariation[meansbcombined$wave <3] <- 0
# create a total bias coefficient
meansbcombined$totalbias <- meansbcombined$Ctraitmeans + meansbcombined$meanmethodfactor

# later plot these in 9 interaction-tables
# Ctraitmeans *
# meanmethodfactor
# totalbias

# or plot these in 3 interaction tables
# Ctraitmeans 
# methodvariation
# totalbias

# now do the same for the quality coefficient
loadingscombined <- loadingscombined[order(loadingscombined$latent),] 
#loadingscombined$mavquality[loadingscombined$wave<4]  <- as.numeric(loadingscombined$quality[loadingscombined$wave<4])
#loadingscombined$mavquality[loadingscombined$wave>3]  <- as.numeric(mav(loadingscombined$quality[loadingscombined$wave>3]))
#loadingscombined$mavCquality[loadingscombined$wave<4] <- as.numeric(loadingscombined$Cquality[loadingscombined$wave<4])
#loadingscombined$mavCquality[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$Cquality[loadingscombined$wave>3]))
loadingscombined$mavreliability[loadingscombined$wave<4]    <- as.numeric(loadingscombined$reliability[loadingscombined$wave<4])
loadingscombined$mavreliability[loadingscombined$wave>3]    <- as.numeric(mav(loadingscombined$reliability[loadingscombined$wave>3]))
loadingscombined$mavvalidity[loadingscombined$wave<4] <- as.numeric(loadingscombined$validity[loadingscombined$wave<4])
loadingscombined$mavvalidity[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$validity[loadingscombined$wave>3]))


loadingscombined$question <- factor(loadingscombined$latent, 
                        levels=c("1","2","3","4","5","6","7","8","9"), 
                        labels=c("parliament, 0-10 battery",
                                 "legal system, 0-10 battery",
                                 "police, 0-10 battery",
                                 "parliament, 0-5  battery",
                                 "legal system, 0-5  battery",
                                 "police, 0-5  battery",
                                 "parliament, 0-10 score",
                                 "legal system, 0-10 score",
                                 "police, 0-10 score"))
meansbcombined$question <- factor(meansbcombined$latent, 
                                    levels=c("1","2","3","4","5","6","7","8","9"), 
                                    labels=c("parliament, 0-10 battery",
                                             "legal system, 0-10 battery",
                                             "police, 0-10 battery",
                                             "parliament, 0-5  battery",
                                             "legal system, 0-5  battery",
                                             "police, 0-5  battery",
                                             "parliament, 0-10 score",
                                             "legal system, 0-10 score",
                                             "police, 0-10 score"))
######################################################################
# make a plot
#install.packages("ggplot2")
require(ggplot2)
library(ggplot2)


#meantraits <- # not in paper, later combied with method means
  ggplot(meansbcombined, aes(y=mavtraitmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of trait factors")+
  ylab("difference in latent means")+
  xlab("waves")+
  labs(colour="Variable")

#methodtraits <- # not in paper, later combied with trait means
ggplot(meansbcombined, aes(y=Cmethodmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of method factors")+
  ylab("difference in latent means")+
  xlab("waves")+
  labs(colour="Variable")
    
#methodvariation <- # not in paper
ggplot(meansbcombined, aes(y=methodvariation, x=wave))+
  geom_point()+
  geom_line()+
  ggtitle("means of Latent trait factors over time")+
  ylab("average difference in method variation")+
  xlab("waves")+
  labs(colour="Variable")

# traitloadings <- #not in paper, later combined with validity
ggplot(loadingscombined, aes(y=reliability, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("Value of reliabilities over time")+
  ylab("reliability coefficient")+
  xlab("waves")+
    ylim(0.8,1.0)+
  labs(colour="Variable")

# validityloadings <- #not in paper, later combined with reliability
ggplot(loadingscombined, aes(y=validity, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of method loadings")+
  ylab("validity coefficient")+
  xlab("waves")+
  ylim(0.8,1.0)+
  labs(colour="Variable")

###################################################################################################
# and repeat for leftright


test0 <- results2
test22 <- as.matrix(unlist(test0),nrow=126,byrow=T)
test3 <- matrix(unlist(test22),nrow=3636,byrow=F)

# extract means, with their se's 
meanstraits <- test3[c(286:288),]
meanmethodfactor <- test3[c(289:291),]
#View(meanmethodfactor)
meantraitse <- test3[c(412:414),]
meanfactorse <- test3[c(415:417),]
# extract trait loadings (for reliability and validity)
traitloadings <-test3[c(1243:1251),]
methodloadings <-test3[c(1252:1260),]
reliabilities <- test3[c(1297:1305),]

#View(traitloadings)
#View(methodloadings)
# now, take the longitudinal datasets, and substract the cross-sectional estimates from wave 1
# because longitudinal datasets is saved as factors, need to change it again 
# make the wave 1 of same size
MTMMmethod <- as.data.frame(matrix(rep(MTMMmethodmeans,35),nrow=3,ncol=35))
Cmethodmeans <- cbind(as.numeric(unlist(MTMMmethod)) - as.numeric(meanmethodfactor))
#View(Cmethodmeans)

# here, we are not merely interested in method means. But in overall variation in method means
# stole this from http://stackoverflow.com/questions/9379065/how-to-sum-grouped-elements-of-a-vector-in-r
# first make it into absolute number
meanmethodfactor <- as.numeric(unlist(meanmethodfactor))
absmethodmeans <- abs(as.numeric(Cmethodmeans)/2)
# View(absmethodmeans)
# then, apply mean function to it.
methodvariation <- tapply(absmethodmeans, (seq_along(absmethodmeans)-1) %/% 3,mean)
#View(methodvariation)

# traitmeans
test4 <- as.numeric(as.character(unlist(meanstraits)))
Ctraitmeans  <- test4 - MTMMtraitmeans

#traitloadings - validity
test5 <- as.numeric(as.character(unlist(traitloadings)))
Ctraitloadings <- test5 - MTMMtraitloadings

#methodloadings - method effects
test6 <- as.numeric(as.character(unlist(methodloadings)))
Cmethodloadings <- as.data.frame(test6 - MTMMmethodloadings)
View(test6)

#reliability
test7 <- 1-as.numeric(as.character(unlist(reliabilities)))
Creliability <- test7 - MTMMreliability

#View(MTMMvalidity)
# compute validity coefficient
validity <- test5
reliability <- test7
#test7 <- as.numeric(as.character(unlist(validity)))
# produces change in validity estimates
Cvalidity <- as.data.frame(validity - MTMMvalidity)
View(Cvalidity)

#test8 <- as.numeric(as.character(unlist(regression)))
#Cregression <- test8 - MTMMregression 

################ now combine item into two objects for plottting
# 9-item for loadings
# 3 items for means + regressioncoefficients 
View(validity)
loadingscombined <- as.data.frame(cbind(reliability,Creliability,validity,Cvalidity)) #1.
meanmethodfactor <- as.numeric(as.character(unlist(meanmethodfactor))) # make it numeric as well
meansbcombined <- as.data.frame(cbind(Ctraitmeans,meanmethodfactor,Cmethodmeans)) #2.
#View(Cmethodmeans)

meansbcombined$methodvariation <- rep(methodvariation)
#View(meansbcombined$methodvariation)
meansbcombined$MTMMmeans <- rep(MTMMmethodmeans,c(35))

#class(loadingscombined)
# now add some handy columns for creating the plots
meansbcombined$latent <- rep(1:3)
loadingscombined$latent <- rep(1:9)
meansbcombined$wave <-   rep(1:35,c(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3))
loadingscombined$wave <- rep(1:35,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))
# now, add one variable that reflects the mean in the change in quality (no longer used)
#loadingsmean <- tapply(loadingscombined$Cquality, (seq_along(loadingscombined$Cquality)-1) %/% 9, mean)
#loadingscombined$means <- rep(loadingsmean,c(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9))

# add up differences in trait and method means
# for this, need to ceate a product matrix - 3 x3.

######################################################################
# I want moving averages to make the plot look nicer. Here is a function I stole 
# http://druedin.com/2012/08/11/moving-averages-in-r/

mav <- function(x,n=3){filter(x,rep(1/n,n), sides=2)}
# ah crap. I need to change the order of the matrix, so that it is ordered on latent.
# use the order variable to order on latent variable
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
#now, add this moving average to the data frame
meansbcombined$mavtraitmeans <- as.numeric(mav(meansbcombined$Ctraitmeans))
# impose a 0 for the first 2 waves (they get an NA in the mav-function)
meansbcombined$mavtraitmeans[meansbcombined$wave <3] <- 0

# now do the same for the method means
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodmeans <- as.numeric(mav(meansbcombined$meanmethodfactor))
meansbcombined$mavmethodmeans[meansbcombined$wave <3] <- 0

#now do the same for method variation 
meansbcombined <- meansbcombined[order(meansbcombined$latent),] 
meansbcombined$mavmethodvariation <- as.numeric(mav(meansbcombined$methodvariation))
meansbcombined$mavmethodvariation[meansbcombined$wave <3] <- 0
# create a total bias coefficient
meansbcombined$totalbias <- meansbcombined$Ctraitmeans + meansbcombined$meanmethodfactor

# later plot these in 9 interaction-tables
# Ctraitmeans *
# meanmethodfactor
# totalbias

# or plot these in 3 interaction tables
# Ctraitmeans 
# methodvariation
# totalbias

# now do the same for the quality coefficient
loadingscombined <- loadingscombined[order(loadingscombined$latent),] 
#loadingscombined$mavquality[loadingscombined$wave<4]  <- as.numeric(loadingscombined$quality[loadingscombined$wave<4])
#loadingscombined$mavquality[loadingscombined$wave>3]  <- as.numeric(mav(loadingscombined$quality[loadingscombined$wave>3]))
#loadingscombined$mavCquality[loadingscombined$wave<4] <- as.numeric(loadingscombined$Cquality[loadingscombined$wave<4])
#loadingscombined$mavCquality[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$Cquality[loadingscombined$wave>3]))
loadingscombined$mavreliability[loadingscombined$wave<4]    <- as.numeric(loadingscombined$reliability[loadingscombined$wave<4])
loadingscombined$mavreliability[loadingscombined$wave>3]    <- as.numeric(mav(loadingscombined$reliability[loadingscombined$wave>3]))
loadingscombined$mavvalidity[loadingscombined$wave<4] <- as.numeric(loadingscombined$validity[loadingscombined$wave<4])
loadingscombined$mavvalidity[loadingscombined$wave>3] <- as.numeric(mav(loadingscombined$validity[loadingscombined$wave>3]))


loadingscombined$question <- factor(loadingscombined$latent, 
                                    levels=c("1","2","3","4","5","6","7","8","9"), 
                                    labels=c("parliament, 0-10 battery",
                                             "legal system, 0-10 battery",
                                             "police, 0-10 battery",
                                             "parliament, 0-5  battery",
                                             "legal system, 0-5  battery",
                                             "police, 0-5  battery",
                                             "parliament, 0-10 score",
                                             "legal system, 0-10 score",
                                             "police, 0-10 score"))
meansbcombined$question <- factor(meansbcombined$latent, 
                                  levels=c("1","2","3","4","5","6","7","8","9"), 
                                  labels=c("parliament, 0-10 battery",
                                           "legal system, 0-10 battery",
                                           "police, 0-10 battery",
                                           "parliament, 0-5  battery",
                                           "legal system, 0-5  battery",
                                           "police, 0-5  battery",
                                           "parliament, 0-10 score",
                                           "legal system, 0-10 score",
                                           "police, 0-10 score"))
######################################################################

#meantraits <- # not in paper, later combied with method means
ggplot(meansbcombined, aes(y=mavtraitmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of trait factors")+
  ylab("difference in latent means")+
  xlab("waves")+
  labs(colour="Variable")

#methodtraits <- # not in paper, later combied with trait means
ggplot(meansbcombined, aes(y=Cmethodmeans, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of method factors")+
  ylab("difference in latent means")+
  xlab("waves")+
  labs(colour="Variable")

#methodvariation <- # not in paper
ggplot(meansbcombined, aes(y=methodvariation, x=wave))+
  geom_point()+
  geom_line()+
  ggtitle("means of Latent trait factors over time")+
  ylab("average difference in method variation")+
  xlab("waves")+
  labs(colour="Variable")

# traitloadings <- #not in paper, later combined with validity
ggplot(loadingscombined, aes(y=reliability, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("Value of reliabilities over time")+
  ylab("reliability coefficient")+
  xlab("waves")+
  ylim(0.8,1.0)+
  labs(colour="Variable")

# validityloadings <- #not in paper, later combined with reliability
ggplot(loadingscombined, aes(y=validity, x=wave, group=question,colour=question))+
  geom_point()+
  geom_line()+
  ggtitle("means of method loadings")+
  ylab("validity coefficient")+
  xlab("waves")+
  ylim(0.8,1.0)+
  labs(colour="Variable")